/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.sTaskASMIntegrity;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskASMIntegrity
extends Task
implements VerificationConstants,
CVUHelperConstants {
    private boolean m_isPreCheck = false;
    private boolean m_isUpgrade = false;
    private String[] m_allClusterNodes = null;
    private String[] m_allASMInstanceNodes = null;
    private String[] m_asmInterfaceArr = null;
    private String[] m_asmSubnetArr = null;
    private int[] m_asmSubnetTypeArr = null;
    private boolean m_mute = false;
    private String[] m_dgList;
    private boolean m_DiskGroupCheck = false;
    private VerificationType m_vtype;
    private boolean m_OCRonASM;
    private String CHECK_IOSERVER_HELPER_ARG = "-getIOServerNodes";
    sTaskASMIntegrity s_sAsmInteg = new sTaskASMIntegrity();

    public TaskASMIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskASMIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskASMIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        boolean doUploadRS;
        ResultSet locrs = new ResultSet();
        Trace.out((String)("Performing ASM Integrity verification task..." + LSEP + "m_isPreCheck=" + this.m_isPreCheck + ": m_asmInterfaceArr='" + VerificationUtil.strArr2List(this.m_asmInterfaceArr) + "'"));
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4391", false) + LSEP);
        }
        String softwareVersion = null;
        if (!this.m_isPreCheck) {
            softwareVersion = VerificationUtil.getCRSSoftwareVersion(this.m_nodeList[0]);
        } else {
            String requestRel = VerificationUtil.getRequestedRelease();
            Trace.out((String)("requestRel=" + requestRel));
            softwareVersion = "10gR1".equalsIgnoreCase(requestRel) || "10.1".equalsIgnoreCase(requestRel) ? "10.1" : ("10gR2".equalsIgnoreCase(requestRel) || "10.2".equalsIgnoreCase(requestRel) ? "10.2" : ("11gR1".equalsIgnoreCase(requestRel) || "11.1".equalsIgnoreCase(requestRel) ? "11.1" : ("11gR2".equalsIgnoreCase(requestRel) || "11.2".equalsIgnoreCase(requestRel) ? "11.2" : (requestRel == null ? "12.1" : requestRel))));
        }
        Trace.out((String)("software version obtained is :" + softwareVersion));
        if (VerificationUtil.isVersionPost(softwareVersion, "12")) {
            doUploadRS = this.performASMNetworkValidation(locrs);
            if (doUploadRS) {
                Trace.out((String)"uploading ASM network validation resultset");
                this.m_resultSet.uploadResultSet(locrs);
            }
            locrs.clear();
            doUploadRS = this.performCredFileValidation(locrs);
            if (doUploadRS) {
                Trace.out((String)"uploading cred file validation resultset");
                this.m_resultSet.uploadResultSet(locrs);
            }
            locrs.clear();
        }
        if ((!this.m_isPreCheck || this.m_isUpgrade) && (doUploadRS = this.performASMInstanceCheck(softwareVersion, locrs))) {
            Trace.out((String)"uploading asm instance check resultset");
            this.m_resultSet.uploadResultSet(locrs);
        }
        if (this.m_resultSet.allSuccess()) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4392", false));
            }
        } else if (!this.m_mute) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4393", false));
        }
        return true;
    }

    private boolean performASMNetworkValidation(ResultSet locrs) {
        String asmPresence = VerificationUtil.getVariableValue("ASMCONFIG");
        if (this.m_isPreCheck && "LOCAL".equalsIgnoreCase(asmPresence)) {
            Trace.out((String)"pre crsisnt and cluster is legacy cluster");
            return false;
        }
        if (!this.m_isPreCheck && CVUHelperUtil.isASMLocal()) {
            Trace.out((String)"post crsinst legacy cluster no network validation required");
            return false;
        }
        if (this.m_asmInterfaceArr == null) {
            String msg;
            Trace.out((String)"ASM network not found in INTERCONNECT_LIST/OIFCFG");
            if (this.m_isPreCheck) {
                if (VerificationUtil.getVariableValue("INTERCONNECT_LIST") == null) {
                    Trace.out((String)"interconnect list not specified");
                    return false;
                }
                Trace.out((String)"interconnect list has been specified");
                msg = m_isCLImode ? s_gMsgBundle.getMessage("1611", true) : s_gMsgBundle.getMessage("1600", true);
            } else {
                msg = s_gMsgBundle.getMessage("1601", true);
            }
            ErrorDescription errDesc = new ErrorDescription(msg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 3);
            return true;
        }
        Trace.out((String)"starting ASM network validation");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("1606", false));
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(this.m_nodeList);
        taskNodeCon.setTaskType(0);
        taskNodeCon.setInterfaceList(this.m_asmInterfaceArr);
        taskNodeCon.setSubnetList(this.m_asmSubnetArr);
        taskNodeCon.setSubnetTypeList(this.m_asmSubnetTypeArr);
        try {
            taskNodeCon.verify();
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
            ReportUtil.sureprintln(e.getMessage());
            return true;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
            ReportUtil.sureprintln(e.getMessage());
            return true;
        }
        locrs.uploadResultSet(taskNodeCon.getResultSet());
        if (!locrs.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1608", true));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1607", false));
        }
        return true;
    }

    private boolean performCredFileValidation(ResultSet locrs) {
        Trace.out((String)"ENTRY");
        if (!this.m_isPreCheck && !CVUHelperUtil.isASMFar()) {
            Trace.out((String)"no credentials to validate as it is not a ASM far cluster");
            return false;
        }
        String credFile = null;
        if (this.m_isPreCheck) {
            credFile = VerificationUtil.getVariableValue("ASM_CLIENTDATA");
            if (credFile == null || credFile.length() == 0) {
                Trace.out((String)"asm cred file not specified pre crsinst");
                return false;
            }
            Trace.out((String)("cred file is: " + credFile));
        }
        Trace.out((String)"getting local host");
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
            String errMsg = s_msgBundle.getMessage("0002", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return true;
        }
        Throwable excpt = null;
        if (this.m_isPreCheck) {
            ReportUtil.println(s_gMsgBundle.getMessage("1602", false, (Object[])new String[]{credFile}));
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("1603", false, (Object[])new String[]{credFile}));
        }
        try {
            String kfodLocation = VerificationUtil.getKFODLocation(localNode, this.m_isPreCheck);
            Trace.out((String)("running kfod from: " + kfodLocation));
            KFODUtil kfodUtil = new KFODUtil(kfodLocation);
            if (this.m_isPreCheck) {
                Trace.out((String)"calling kfod before clusterware install");
                kfodUtil.validateASMCredentials(credFile);
            } else {
                Trace.out((String)"calling kfod after clusterware install");
                kfodUtil.validateASMCredentials();
            }
        }
        catch (CmdToolUtilException e) {
            excpt = e;
        }
        catch (VerificationException e) {
            excpt = e;
        }
        if (excpt != null) {
            String errMsg = null;
            errMsg = this.m_isPreCheck ? s_gMsgBundle.getMessage("1604", true, (Object[])new String[]{credFile}) : s_gMsgBundle.getMessage("1605", true);
            errMsg = errMsg + LSEP + excpt.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg);
            return true;
        }
        locrs.addResult(this.m_nodeList, 1);
        if (this.m_isPreCheck) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1609", false, (Object[])new String[]{credFile}));
        } else {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1610", false));
        }
        return true;
    }

    private boolean performASMInstanceCheck(String softwareVersion, ResultSet locrs) {
        ErrorDescription errDesc = null;
        if (VerificationUtil.isHAConfigured() && this.m_nodeList.length > 1) {
            String prMsg = s_gMsgBundle.getMessage("5741", true);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            ErrorDescription erD = new ErrorDescription(prMsg);
            locrs.addResult(this.m_nodeList[0], 2);
            locrs.addErrorDescription(erD);
            Trace.out((String)"More than one node not valid in SIHA  environment.Check exiting");
            return true;
        }
        try {
            Trace.out((int)5, (String)"get the cluster nodes");
            this.m_allClusterNodes = VerificationUtil.getNodelistFromOlsnodesWithException();
        }
        catch (NodelistNotFoundException e) {
            Trace.out((int)5, (String)("Failed to get the cluster nodes :: " + e.getMessage()));
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1008", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList, ",")}) + LSEP + e.getMessage());
            locrs.addResult(this.m_nodeList, 2);
            return true;
        }
        Trace.out((String)("m_allClusterNodes::" + VerificationUtil.strArr2List(this.m_allClusterNodes)));
        if (!this.m_nodeMgr.isBigCluster()) {
            this.m_allASMInstanceNodes = this.m_allClusterNodes;
        } else {
            try {
                Trace.out((int)5, (String)"get active hub nodes");
                this.m_allASMInstanceNodes = this.m_nodeMgr.getActiveHubNodes();
            }
            catch (NoSuchNodesException e) {
                Trace.out((int)5, (String)("Failed to get the active cluster nodes :: " + e.getMessage()));
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1008", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList, ",")}) + LSEP + e.getMessage());
                locrs.addResult(this.m_nodeList, 2);
                return true;
            }
        }
        Trace.out((String)("m_allASMInstanceNodes::" + VerificationUtil.strArr2List(this.m_allASMInstanceNodes)));
        ArrayList<String> runningASMNodes = new ArrayList<String>();
        ArrayList<String> failedASMNodes = new ArrayList<String>();
        boolean isPre12c = VerificationUtil.isVersionPre(softwareVersion, "12");
        if (isPre12c || !CVUHelperUtil.isASMFar()) {
            Trace.out((String)"Starting ASM Running check...");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5107", false));
            ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
            try {
                Trace.out((int)5, (String)"determine the nodes on which ASM is running");
                asmdg.checkASMRunning(this.m_allASMInstanceNodes, runningASMNodes, failedASMNodes);
            }
            catch (ASMDiskGroupsUtilException e) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1008", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList, ",")}) + LSEP + e.getMessage());
                locrs.addResult(this.m_nodeList, 2);
                for (String node : this.m_nodeList) {
                    failedASMNodes.add(node);
                }
                Trace.out((String)("Error determining ASM running nodes " + e));
            }
            if (isPre12c || CVUHelperUtil.isASMLocal()) {
                ArrayList<String> runningASMNodesOriginalList = new ArrayList<String>();
                ArrayList<String> failedASMNodesOriginalList = new ArrayList<String>();
                runningASMNodesOriginalList.addAll(runningASMNodes);
                runningASMNodesOriginalList.retainAll(Arrays.asList(this.m_nodeList));
                failedASMNodesOriginalList.addAll(failedASMNodes);
                failedASMNodesOriginalList.retainAll(Arrays.asList(this.m_nodeList));
                for (String node : runningASMNodesOriginalList) {
                    locrs.addResult(node, 1);
                }
                for (String node : failedASMNodesOriginalList) {
                    locrs.addResult(node, 3);
                }
            } else if (CVUHelperUtil.isASMNear()) {
                int expectedASMInstCount;
                int asmCount = CVUHelperUtil.getASMCount();
                if (asmCount == -1) {
                    expectedASMInstCount = this.m_allASMInstanceNodes.length;
                } else {
                    int n = expectedASMInstCount = asmCount > this.m_allASMInstanceNodes.length ? this.m_allASMInstanceNodes.length : asmCount;
                }
                if (runningASMNodes.size() >= expectedASMInstCount) {
                    locrs.addResult(this.m_nodeList, 1);
                } else {
                    locrs.addResult(this.m_nodeList, 3);
                }
            }
            locrs.setStatus();
            this.reportASMRunningStatus(runningASMNodes, failedASMNodes, locrs, isPre12c);
            Trace.out((int)5, (String)"ASM Running check on all nodes completed.");
            if (runningASMNodes.isEmpty()) {
                return true;
            }
        }
        if (!this.m_DiskGroupCheck) {
            if (this.m_vtype == VerificationType.PREREQ_DB_INST) {
                this.checkDiskGroupsforDB();
            } else {
                this.checkDiskGroupsASM();
            }
        }
        return true;
    }

    private void performIOServerExistanceCheck(List<String> runningASMNodes, ResultSet locrs) {
        String errMsg;
        String[] args = new String[]{this.CHECK_IOSERVER_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        Trace.out((String)"executing cvuhelper to get ioserver nodes");
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg2 = s_gMsgBundle.getMessage("6057", true, (Object[])new String[]{"cvuhelper " + this.CHECK_IOSERVER_HELPER_ARG}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg2);
            locrs.addResult(this.m_nodeList, 2);
            locrs.addErrorDescription(errDesc);
            VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + e.getMessage());
            ReportUtil.sureprintln(errMsg2);
            return;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg3 = s_gMsgBundle.getMessage("6057", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            locrs.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg3);
            locrs.addErrorDescription(errDesc);
            VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + helperExec.getErrorString());
            ReportUtil.sureprintln(errMsg3);
            return;
        }
        String[] output = helperExec.getOutput();
        int iosCount = 0;
        String[] iosRunningNodes = new String[]{};
        String[] errorArray = null;
        String[] iosInfoArr = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            VerificationLogData.log(outputStr);
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"failed to get ioserver count and nodes");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg4 = VerificationUtil.strArr2String(errorArray, LSEP);
                ErrorDescription errDesc = new ErrorDescription(errMsg4);
                locrs.addResult(this.m_nodeList, 3);
                locrs.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg4);
                VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + errMsg4);
                return;
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg5 = s_gMsgBundle.getMessage("6057", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg5 = errMsg5 + LSEP + helperExec.getErrorString();
            }
            locrs.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg5);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg5);
            VerificationLogData.logError("cvuhelper -getIOServerNodes command failed" + errStr);
            return;
        }
        Trace.out((String)"fetching successful nodes");
        iosInfoArr = CVUHelperUtil.fetchOutput(output);
        String iosCountStr = VerificationUtil.fetchTextByTags(iosInfoArr[0], "<IOS_COUNT>", "</IOS_COUNT>");
        if (iosCountStr != null && iosCountStr.length() > 0) {
            Trace.out((String)("io server count is " + iosCountStr));
            iosCount = Integer.parseInt(iosCountStr);
        }
        if (iosCount == 0) {
            locrs.addResult(this.m_nodeList, 1);
            return;
        }
        int expectedIOSCount = iosCount == -1 ? this.m_allASMInstanceNodes.length : (iosCount > this.m_allASMInstanceNodes.length ? this.m_allASMInstanceNodes.length : iosCount);
        ReportUtil.println(s_gMsgBundle.getMessage("6060", false));
        String iosOutputNodeStr = VerificationUtil.fetchTextByTags(iosInfoArr[0], "<IOS_NODES>", "</IOS_NODES>");
        Object iosOutputNodeArr = null;
        if (iosOutputNodeStr != null && iosOutputNodeStr.length() != 0) {
            iosRunningNodes = VerificationUtil.string2strArr(iosOutputNodeStr);
            Trace.out((String)("ioServers are running on " + iosRunningNodes.length + " nodes and they are" + iosOutputNodeStr));
        } else {
            Trace.out((String)"No running ioservers are available");
        }
        Trace.out((String)("iosCount=" + iosCount + "; m_nodeList.length=" + this.m_nodeList.length));
        Trace.out((String)("expectedIOSCount=" + expectedIOSCount));
        if (expectedIOSCount > iosRunningNodes.length) {
            errMsg = s_gMsgBundle.getMessage("6059", true, (Object[])new String[]{Integer.toString(expectedIOSCount), Integer.toString(iosRunningNodes.length)});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 4);
            locrs.addErrorDescription(errDesc);
            ReportUtil.printWarning(errMsg);
            VerificationLogData.logError("ioserver running on insufficient nodes actual =" + iosRunningNodes.length + " required=" + expectedIOSCount);
        } else {
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("6058", false));
        }
        if (CVUHelperUtil.isASMFar()) {
            Trace.out((String)"far asm so no checking of io server running on asm nodes");
            return;
        }
        ArrayList<String> iosWithoutASM = new ArrayList<String>();
        for (int i = 0; i < iosRunningNodes.length; ++i) {
            if (runningASMNodes.contains(iosRunningNodes[i])) continue;
            Trace.out((String)("asm not running on node " + iosRunningNodes[i]));
            VerificationLogData.log("ios running on ASM not running on node " + iosRunningNodes[i]);
            iosWithoutASM.add(iosRunningNodes[i]);
        }
        if (iosWithoutASM.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("6061", true, (Object[])new String[]{VerificationUtil.strList2List(iosWithoutASM)});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addResult(this.m_nodeList, 4);
            locrs.addErrorDescription(errDesc);
            ReportUtil.printWarning(errMsg);
        }
        Trace.out((int)2, (String)"Exit");
    }

    private void reportASMRunningStatus(List<String> runningASMNodes, List<String> failedASMNodes, ResultSet locrs, boolean isPre12c) {
        Trace.out((int)2, (String)"Entry");
        Trace.out((int)5, (String)"Reporting ASM Running status for the nodes");
        Trace.out((int)5, (String)("No of nodes running ASM = " + runningASMNodes.size()));
        Trace.out((int)5, (String)("No of nodes NOT running ASM = " + failedASMNodes.size()));
        if (runningASMNodes.size() == this.m_allASMInstanceNodes.length) {
            Trace.out((int)5, (String)"ASM is running on all cluster nodes.");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
        } else if (failedASMNodes.size() == this.m_allASMInstanceNodes.length) {
            Trace.out((int)5, (String)"ASM is NOT running on all cluster nodes.");
            String errMsg = LSEP + s_msgBundle.getMessage("5109", true);
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
        } else if (!isPre12c && CVUHelperUtil.isASMNear()) {
            int expectedASMInstCount;
            int asmCount = CVUHelperUtil.getASMCount();
            if (asmCount == -1) {
                expectedASMInstCount = this.m_allASMInstanceNodes.length;
            } else {
                int n = expectedASMInstCount = asmCount > this.m_allASMInstanceNodes.length ? this.m_allASMInstanceNodes.length : asmCount;
            }
            if (runningASMNodes.size() >= expectedASMInstCount) {
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("6055", false));
                this.m_resultSet.addResult(this.m_nodeList, 1);
            } else {
                String msg = s_gMsgBundle.getMessage("6056", true, (Object[])new String[]{expectedASMInstCount + "", runningASMNodes.size() + "", VerificationUtil.strList2List(runningASMNodes)});
                ReportUtil.sureprintln(LSEP + msg + LSEP);
                locrs.addErrorDescription(new ErrorDescription(msg));
            }
        } else {
            ArrayList<String> failedASMNodesOriginalList = new ArrayList<String>();
            failedASMNodesOriginalList.addAll(failedASMNodes);
            failedASMNodesOriginalList.retainAll(Arrays.asList(this.m_nodeList));
            String nodel = VerificationUtil.strList2List(failedASMNodesOriginalList);
            locrs.addErrorDescription(failedASMNodesOriginalList, new ErrorDescription(s_msgBundle.getMessage("5110", true, (Object[])new String[]{nodel})));
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5110", true, (Object[])new String[]{nodel}));
        }
        Trace.out((int)2, (String)"Exit");
    }

    private boolean checkDiskGroupsforDB() {
        boolean getdg;
        Trace.out((int)2, (String)"Entry");
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("5139", false));
        if (this.m_dgList == null || this.m_dgList.length == 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5138", true));
            return false;
        }
        ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil();
        Hashtable<String, List<ASMDiskGroup>> htdg = new Hashtable<String, List<ASMDiskGroup>>();
        Hashtable<String, ASMDiskGroup> htreqddg = new Hashtable<String, ASMDiskGroup>();
        ResultSet dgResultSet = new ResultSet();
        try {
            getdg = dgutil.getDiskGroups(this.m_nodeList, dgResultSet, htdg);
        }
        catch (ASMDiskGroupsUtilException e) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5131", true));
            this.m_resultSet.uploadResultSet(dgResultSet);
            this.m_resultSet.setStatus();
            return false;
        }
        this.m_resultSet.uploadResultSet(dgResultSet);
        if (getdg) {
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5143", false));
            for (String dgnm : this.m_dgList) {
                Vector<String> unavailnodes = new Vector<String>();
                for (String node : this.m_nodeList) {
                    List<ASMDiskGroup> dgl = htdg.get(node);
                    if (dgl == null || dgl.size() < 1) {
                        unavailnodes.add(node);
                        continue;
                    }
                    boolean founddg = false;
                    for (ASMDiskGroup dg1 : dgl) {
                        if (!dg1.getName().equals(dgnm)) continue;
                        if (htreqddg.get(dgnm) == null) {
                            htreqddg.put(dgnm, dg1);
                        }
                        founddg = true;
                    }
                    if (founddg) continue;
                    unavailnodes.add(node);
                }
                if (unavailnodes.size() > 0) {
                    if (unavailnodes.size() < this.m_nodeList.length) {
                        ReportUtil.sureprintln(s_msgBundle.getMessage("5144", true, (Object[])new String[]{dgnm, unavailnodes.toString()}));
                        continue;
                    }
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5145", true, (Object[])new String[]{dgnm}));
                    continue;
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5146", false, (Object[])new String[]{dgnm}));
            }
            ReportUtil.sureblankln();
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5148", false));
            if (htreqddg != null && htreqddg.size() > 0) {
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("5133", false), s_msgBundle.getMessage("5134", false), s_msgBundle.getMessage("5135", false));
                Enumeration dgenum = htreqddg.keys();
                while (dgenum.hasMoreElements()) {
                    String dgnam = (String)dgenum.nextElement();
                    ASMDiskGroup adg = (ASMDiskGroup)htreqddg.get(dgnam);
                    ReportUtil.writeRecord(adg.getName(), Double.toString(adg.getSize().sizeIn(StorageUnit.MBYTE)), Double.toString(adg.getFree().sizeIn(StorageUnit.MBYTE)));
                    if (!(adg.getFree().sizeIn(StorageUnit.MBYTE) < 400.0)) continue;
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5136", false, (Object[])new String[]{adg.getName(), new Long(400L).toString()}));
                    Trace.out((String)("INSUFFICIENT SIZE OF DISKGROUP" + adg.getName() + ": MIN REQD=" + 400L + ", DISKGROUP SIZE=" + adg.getSize()));
                }
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5132", true));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5140", false));
            return true;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5131", false));
        ReportUtil.sureprintln(s_msgBundle.getMessage("5140", false));
        return false;
    }

    private void checkDiskGroupsASM() {
        Trace.out((int)2, (String)"Entry");
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        Trace.out((int)5, (String)"Starting ASM DiskGroup check...");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5111", false));
        int dgLocalCount = 0;
        try {
            dgLocalCount = asmdg.getDiskGroupCount();
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((int)5, (String)("Exception when getting disk groups list from ASM" + e));
            ReportUtil.sureprintln(s_msgBundle.getMessage("5112", true));
        }
        if (dgLocalCount > 0) {
            Trace.out((int)5, (String)"DiskGroup Check: At least ONE Disk Group found.");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5113", false));
        } else {
            Trace.out((int)5, (String)"DiskGroup Check: WARNING - No Disk Groups have been configured.");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5114", true));
        }
        Trace.out((int)5, (String)"DiskGroup Check: Completed.");
    }

    private void checkFilterDriverManagedDisks(List<String> asmFDNodeList, ResultSet rs) {
        String errMsg;
        String nodeStr = VerificationUtil.strList2List(asmFDNodeList);
        HashMap<String, List> kfodNodeDiskMap = new HashMap<String, List>();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("6065", false, (Object[])new String[]{nodeStr}));
        Throwable excpt = null;
        String afdCommand = this.s_sAsmInteg.getAFDDisksCommand();
        ArrayList<String> failedNodes = new ArrayList<String>();
        try {
            String errMsg2;
            String kfodLocation = VerificationUtil.getKFODLocation(asmFDNodeList.get(0), this.m_isPreCheck);
            Trace.out((String)("running kfod from: " + kfodLocation));
            KFODUtil kfodUtil = new KFODUtil(kfodLocation);
            for (String node : asmFDNodeList) {
                Trace.out((String)("calling kfod on node " + node));
                List kfodDiskList = kfodUtil.getASMDiskList(node);
                kfodNodeDiskMap.put(node, kfodDiskList);
            }
            VerificationCommand[] afdtoolCmdArr = new VerificationCommand[asmFDNodeList.size()];
            int cmdCount = 0;
            String[] env = null;
            for (String node : asmFDNodeList) {
                Result result;
                String crsHome = VerificationUtil.getCRSHome(node, result = new Result(node));
                if (crsHome == null) {
                    rs.addResult(node, 2);
                    errMsg2 = s_msgBundle.getMessage("5301", true);
                    ErrorDescription errorDesc = new ErrorDescription(errMsg2);
                    rs.addErrorDescription(node, errorDesc);
                    ReportUtil.printError(errMsg2);
                    continue;
                }
                String[] args = new String[]{"-rungencmd", crsHome + afdCommand};
                afdtoolCmdArr[cmdCount++] = new VerificationCommand(node, args, env);
            }
            Trace.out((String)"executing afdtool on all nodes");
            new GlobalHandler().submit((Command[])afdtoolCmdArr, 0, rs);
            if (!rs.anySuccess()) {
                Trace.out((String)("Global failure executing afdtool command " + afdCommand));
                String errMsg3 = s_gMsgBundle.getMessage("6067", false, (Object[])new String[]{afdCommand});
                ErrorDescription errorDesc = new ErrorDescription(errMsg3);
                rs.addErrorDescription(errorDesc);
                ReportUtil.sureprintln(errMsg3);
                return;
            }
            for (int i = 0; i < cmdCount; ++i) {
                VerificationCommand afdCmd = afdtoolCmdArr[i];
                String node = afdCmd.getNode();
                Result result = afdCmd.getResult();
                if (result.getStatus() == 1) {
                    String output = afdCmd.getOutput();
                    if (output == null) {
                        Trace.out((String)("no output from afdtool on node " + node));
                        String errMsg4 = s_gMsgBundle.getMessage("6068", true, (Object[])new String[]{afdCommand, node});
                        ErrorDescription errDesc = new ErrorDescription(errMsg4);
                        rs.addErrorDescription(errDesc);
                        rs.addResult(node, 4);
                        failedNodes.add(node);
                        continue;
                    }
                    String[] afdDiskArr = VerificationUtil.string2strArr(output, LSEP);
                    List<String> afdDiskList = Arrays.asList(afdDiskArr);
                    List kfodDiskList = (List)kfodNodeDiskMap.get(node);
                    ArrayList<String> notAFDManagedDiskList = new ArrayList<String>();
                    for (String kfodDisk : kfodDiskList) {
                        if (afdDiskList.contains(kfodDisk)) continue;
                        notAFDManagedDiskList.add(kfodDisk);
                    }
                    if (notAFDManagedDiskList.size() == 0) continue;
                    String errMsg5 = s_gMsgBundle.getMessage("6069", true, (Object[])new String[]{VerificationUtil.strList2List(notAFDManagedDiskList), node});
                    rs.addResult(node, 4);
                    ErrorDescription errDesc = new ErrorDescription(errMsg5);
                    rs.addErrorDescription(node, errDesc);
                    ReportUtil.printWarning(errMsg5);
                    continue;
                }
                Trace.out((String)("afdtool command failed to execute on node " + node));
                errMsg2 = s_gMsgBundle.getMessage("6070", true, (Object[])new String[]{node, afdCommand}) + LSEP + result.getErrMessage();
                ReportUtil.sureprintln(errMsg2);
                ErrorDescription errDesc = new ErrorDescription(errMsg2);
                rs.addResult(node, 2);
                rs.addErrorDescription(errDesc);
            }
        }
        catch (CmdToolUtilException e) {
            excpt = e;
        }
        catch (VerificationException e) {
            excpt = e;
        }
        if (excpt != null) {
            errMsg = s_gMsgBundle.getMessage("6066", true, (Object[])new String[]{nodeStr});
            errMsg = errMsg + LSEP + excpt.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            rs.addResult(this.m_nodeList, 2);
            rs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg);
            return;
        }
        if (failedNodes.size() > 0) {
            errMsg = s_gMsgBundle.getMessage("6068", true, (Object[])new String[]{afdCommand, VerificationUtil.strList2List(failedNodes)});
            ReportUtil.printWarning(errMsg);
        }
    }

    public void setASMDGList(String[] dgList) {
        this.m_dgList = dgList;
    }

    public void setASMDGList(String dgName) {
        this.setASMDGList(new String[]{dgName});
    }

    public String[] getASMDGList() {
        return this.m_dgList;
    }

    public void setPreCheck(boolean preCheck) {
        this.m_isPreCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_isPreCheck;
    }

    public void setUpgradeMode(boolean isUpgrade) {
        this.m_isUpgrade = isUpgrade;
    }

    public void setNoDiskGroupCheck(boolean noDGCheck) {
        this.m_DiskGroupCheck = noDGCheck;
    }

    public void setNetworkInfo(String[] asmInterfaceArr, String[] asmSubnetArr, int asmCount) {
        this.m_asmInterfaceArr = new String[asmCount];
        this.m_asmSubnetArr = new String[asmCount];
        this.m_asmSubnetTypeArr = new int[asmCount];
        for (int i = 0; i < asmCount; ++i) {
            this.m_asmInterfaceArr[i] = asmInterfaceArr[i];
            this.m_asmSubnetArr[i] = asmSubnetArr[i];
            this.m_asmSubnetTypeArr[i] = 128;
        }
    }

    public void setNetworkInfoFromOifcfg() throws CVUException {
        ClusterNetworkInfo cnInfo = null;
        Trace.out((String)"calling ClusterNetworkInfo.getNetworkInfoFromOifcfg");
        cnInfo = ClusterNetworkInfo.getNetworkInfoFromOifcfg();
        Trace.out((String)"Successful return from ClusterNetworkInfo.getNetworkInfoFromOifcfg");
        String[] interFaceLst = cnInfo.getIfNames();
        String[] subnetLst = cnInfo.getSubnets();
        int[] subnetTypeLst = cnInfo.getNetTypes(true);
        if (cnInfo.hasNetType(128)) {
            Trace.out((String)"Found NETTYPE_ASM in network information");
            ClusterNetworkInfo asmNetInfo = cnInfo.getClusterNetworkInfo(128);
            String[] asmInterFaceLst = asmNetInfo.getIfNames();
            String[] asmSubnetLst = asmNetInfo.getSubnets();
            int asmCount = asmInterFaceLst.length;
            this.setNetworkInfo(asmInterFaceLst, asmSubnetLst, asmCount);
        }
    }

    public void setVerificationType(VerificationType vtype) {
        this.m_vtype = vtype;
    }

    public void setOCRonASM(boolean isOCRonASM) {
        this.m_OCRonASM = isOCRonASM;
    }

    public boolean isASMNetworkExist() {
        return this.m_asmInterfaceArr != null;
    }

    public void setMute() {
        this.m_mute = true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("6500", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("6700", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

